#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>


PGG_QUERY_ID((ymod_cachedb)(query), Uid, std::int64_t)
PGG_QUERY_ID((ymod_cachedb)(query), Key, std::string)
PGG_QUERY_ID((ymod_cachedb)(query), Value, std::string)
PGG_QUERY_ID((ymod_cachedb)(query), DataType, std::string)

BOOST_FUSION_DEFINE_STRUCT((ymod_cachedb)(result),
    Get,
    (std::string, value)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_cachedb)(result),
    Put,
    (bool, value)
)

namespace ymod_cachedb::query {

struct Get: pgg::query::QueryImpl<Get, Uid, Key, DataType> {
    using Inherited::Inherited;
};

struct Put: pgg::query::QueryImpl<Put, Uid, Key, Value, DataType> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
    Get,
    Put
>;
using ParametersRegister = pgg::query::RegisterParameters<>;

}
