#pragma once

#include <mail_errors/error_code.h>
#include <boost/serialization/strong_typedef.hpp>


namespace ymod_cachedb {

BOOST_STRONG_TYPEDEF(std::string, Value)
using OptValue = std::optional<Value>;
BOOST_STRONG_TYPEDEF(std::int64_t, Uid)
BOOST_STRONG_TYPEDEF(std::string_view, Key)
BOOST_STRONG_TYPEDEF(std::string_view, RequestId)
BOOST_STRONG_TYPEDEF(std::string_view, DataType)

using CallbackGet = std::function<void(mail_errors::error_code, OptValue)>;
using CallbackPut = std::function<void(mail_errors::error_code, bool)>;

}
