#pragma once

#include <boost/system/error_code.hpp>

namespace NYmodHttpWatcher::NQloudInstances {

enum EErrorCode {
    EC_OK = 0,

    // результат разбора ответа
    EC_PARSE_ERROR,
    EC_UNKNOWN_STATE,
    EC_EMPTY_FQDN,
    EC_INVALID_ID,

    // http-коды
    EC_BAD_REQUEST,
    EC_UNAUTHORIZED,
    EC_PERMISSION_DENIED,
    EC_NOT_FOUND,
    EC_SERVER_ERROR,

    // прочее
    EC_UNKNOWN
};

EErrorCode FromHttpStatus(int httpStatus);

boost::system::error_code make_error_code(EErrorCode code);

} // namespace NYmodHttpWatcher::NQloudInstances

namespace boost::system {

template <>
struct is_error_code_enum<NYmodHttpWatcher::NQloudInstances::EErrorCode> : std::true_type{};

} // namespace boost::system
