#pragma once

#include <functional>
#include <memory>
#include <string>

namespace NYmodHttpWatcher::NQloudInstances {

class IHostChecker {
public:
    using TCallback = std::function<void(bool)>;

    virtual ~IHostChecker() = default;
    virtual void AsyncCheck(std::string host, TCallback callback) = 0;
};

using THostCheckerPtr = std::shared_ptr<IHostChecker>;

} // namespace NYmodHttpWatcher::NQloudInstances
