#pragma once

#include "host_checker.h"
#include "parser.h"

#include <ymod_httpclient/call.h>

#include <yplatform/coroutine.h>
#include <yplatform/log.h>

#include <functional>
#include <string>
#include <vector>

namespace NYmodHttpWatcher::NQloudInstances {

class THostListBuilder : public yplatform::log::contains_logger {
public:
    using THosts = std::vector<std::string>;
    using TCallback = std::function<void(std::string localHost, THosts hosts)>;
    using TYieldCtx = yplatform::yield_context<THostListBuilder>;

    THostListBuilder(
        const yhttp::response& response,
        const THosts& prevHosts,
        THostCheckerPtr hostChecker,
        TCallback callback);

    void operator()(TYieldCtx yieldCtx, bool alive = true);

private:
    void HandleResponse();
    void CheckResidingInstances();
    void CallbackIfNeed();

private:
    const yhttp::response& HttpResponse;
    const THosts& PrevHosts;
    THostCheckerPtr HostChecker;
    TCallback Callback;

    boost::system::error_code ErrorCode;
    TReducedInstances Instances;
    std::vector<TReducedInstances::iterator> ResidingInstances;
};

} // namespace NYmodHttpWatcher::NQloudInstances
