#pragma once

#include "errors.h"

#include <ymod_httpclient/call.h>

#include <list>
#include <map>
#include <string>

namespace NYmodHttpWatcher::NQloudInstances {

enum class EState {
    New,
    Existing,
    Residing,
};

using TInstance = std::pair<EState, std::string>;
using TInstances = std::multimap<uint64_t, TInstance>;
using TReducedInstances = std::list<TInstance>;
using TParseRes = std::pair<EErrorCode, TInstances>;

TParseRes ParseResponse(const yhttp::response& response);
TParseRes ParseSuccessResponse(const std::string& body);

TReducedInstances ReduceInstances(TInstances instances);

} // namespace NYmodHttpWatcher::NQloudInstances
