#include "watcher.h"
#include "watcher_impl.h"

#include <yplatform/module_registration.h>

namespace NYmodHttpWatcher {

TWatcher::TWatcher(yplatform::reactor& reactor)
    : Impl(std::make_unique<TWatcherImpl>(reactor))
{}

void TWatcher::init(const yplatform::ptree& configuration) {
    Impl->logger(logger());
    Impl->Init(configuration);
}

void TWatcher::stop() {
    Impl->Stop();
}

void TWatcher::SetHandler(THandler handler) {
    Impl->SetHandler(std::move(handler));
}

void TWatcher::SetErrorHandler(TErrorHandler handler) {
    Impl->SetErrorHandler(std::move(handler));
}

} // namespace NYmodHttpWatcher

REGISTER_MODULE(NYmodHttpWatcher::TWatcher)
