#pragma once

#include "types.h"

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <yplatform/ptree.h>

#include <memory>

namespace NYmodHttpWatcher {

class TWatcherImpl;

class TWatcher : public yplatform::module {
public:
    explicit TWatcher(yplatform::reactor& reactor);

    void init(const yplatform::ptree& configuration);
    void stop();

    void SetHandler(THandler handler);
    void SetErrorHandler(TErrorHandler handler);

private:
    std::unique_ptr<TWatcherImpl> Impl;
};

} // namespace NYmodHttpWatcher
