#include "worker.h"

#include <yplatform/yield.h>

namespace NYmodHttpWatcher {

TWorker::TWorker(
    yhttp::request request,
    TPeriod period,
    boost::asio::io_context& io,
    THttpClientPtr client,
    THandler handler,
    TErrorHandler errorHandler
)
    : Request(std::move(request))
    , Period(period)
    , Timer(io)
    , HttpClient(std::move(client))
    , Handler(std::move(handler))
    , ErrorHandler(std::move(errorHandler))
    , Ctx(new yplatform::task_context())
{}

void TWorker::operator()(TYieldCtx yieldCtx, boost::system::error_code ec, yhttp::response response) {
    if (ec == boost::asio::error::operation_aborted) {
        return;
    }

    reenter (yieldCtx) {
        for (;;) {
            yield HttpClient->async_run(Ctx, Request, yieldCtx);

            try {
                if (ec) {
                    ErrorHandler(ec);
                } else {
                    Handler(response);
                }
            } catch (const std::exception& exp) {
                YLOG_L(error) << "Unhandled exception: " << exp.what();
            }

            if (Ctx->is_cancelled()) {
                break;
            }

            Timer.expires_after(Period);
            yield Timer.async_wait(yieldCtx);
        }
    }
}

void TWorker::Stop() {
    Ctx->cancel();
    Timer.cancel();
}

} // namespace NYmodHttpWatcher
