#pragma once

#include "types.h"

#include <yplatform/coroutine.h>
#include <yplatform/log.h>
#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>

#include <boost/system/error_code.hpp>

#include <functional>

namespace NYmodHttpWatcher {

class TWorker : public yplatform::log::contains_logger {
public:
    using TYieldCtx = yplatform::yield_context<TWorker>;

    TWorker(
        yhttp::request request,
        TPeriod period,
        boost::asio::io_context& io,
        THttpClientPtr client,
        THandler handler,
        TErrorHandler errorHandler);

    void operator()(
        TYieldCtx yieldCtx,
        boost::system::error_code ec = {},
        yhttp::response response = {});

    void Stop();

private:
    yhttp::request Request;
    TPeriod Period;
    yplatform::time_traits::timer Timer;
    THttpClientPtr HttpClient;
    THandler Handler;
    TErrorHandler ErrorHandler;
    yplatform::task_context_ptr Ctx;
};

} // namespace NYmodHttpWatcher
