## Ретраи

### Мотивация
Различные сбои в работе сети, аварии в датацентрах, крэши приложений и другие проблемы могут приводить к ошибкам выполнения запросов. Разумным решением этой проблемы является добавление перезапросов. Однако бездумное добавление перезапросов может приводить к еще большим проблемам. Многие возникающие проблемы хорошо изучены в индустрии, а их решения внедрены в cluster_client.

Базовые настройки:
```yaml
retry_policy:
    max_attempts: 3 # максимальное количество попыток на запрос
    codes: [500, 502, 503, 504] # список HTTP кодов, которые нужно ретраить
```

Помимо кодов из секции `retry_policy.codes` будут ретраиться сетевые ошибки, таймауты и прочее (см. [полный список ошибок](https://a.yandex-team.ru/arc/trunk/arcadia/mail/ymod_httpclient/include/ymod_httpclient/detail/call_with_retries_op.h?rev=r8352863#L16)).

### Бюджет ретраев
Основной проблемой при добавлении ретраев является мультиплицирование нагрузки.

Рассмотрим пример. Пусть имеется связка из 3 бэкендов, в каждом из которых включено по 3 попытки на запрос. Тогда ошибки на бэкенде C будут приводить к росту нагрузки x9. С ростом количества бэкендов в цепочке нагрузка будет расти экспоненциально.

![img](https://jing.yandex-team.ru/files/kharybin/otkazoustoichivost.key_2020-01-17_16-50-45.png)

Чтобы снизить остроту этой проблемы, вводится бюджет ретраев - ограничение на процент ретраев в общей массе запросов. Т.е. если бюджет ретраев равен 20%, то из всех запросов бэкенда A в бэкенд B будет не более 20% ретраев. Это позволяет снизить нагрузку с x9 до x1.44.

![img](https://jing.yandex-team.ru/files/kharybin/otkazoustoichivost.key_2020-01-17_16-50-16.png)

Состояние бюджета можно посмотреть в выдаче статсервера:

```json
"retries": {
    "budget": "0.200000",
    "ratio": "0.000000"
}
```

По умолчанию бюджет ретраев не используется. Чтобы его включить, нужно заполнить соответсвующую секцию в конфиге:
```yaml
retry_policy:
    stats_period: 5 # бюджет считается за последние 5 секунд
    budget:
        value: 0.2  # 20% допустимо ретраев в общей массе запросов
```

Рекомендуемый размер окна для сбора статистики составляет 5-10 секунд. Если поставить его слишком большим, то во время аварии бюджет не будет работать первые несколько секунд, т.к. накопит слишком много статистики работы без ошибок.

Само значение бюджета зависит от количества бэкендов в цепочке. Чем больше бэкендов, тем меньше нужно делать бюджет. В большинстве случаев достаточно 20-30 процентов. Это позволяет успешно ретраить отдельные запросы и не заваливать бэкенды нагрузкой.

### Экспоненциальный backoff
Выполнение ретраев подряд, без задержек, черевато несколькими проблемами:
1. Взрывной рост нагрузки.
Кратковременный флап сети и другие подобные проблемы могут спровоцировать резкий рост нагрузки и последующую перегрузку.
1. Бессмысленные ретраи.
В некоторых случаях поспешные ретраи обречены на провал. Например, не стоит сразу же ретраить ошибки вызванные переключением мастера БД, т.к. эта операция не мгновенная.

Поэтому между ретраями стоит добавлять задержки. В ситуации, когда мы не знаем сколько точно будут продолжаться ошибки, хорошим решением является экспоненциальное увеличение времени задержки после каждой попытки.

Чтобы включить backoff, в конфиг нужно добавить соответствующую секцию:
```yaml
retry_policy:
    backoff:
        base: 500ms  # стартовая задержка между ретраями
        max: 2s  # максимальная задержка между ретраями
        multiplier: 2  # множитель задержки по итерациям
```

Для корректной настройки бэкоффа необходимо учитывать значение таймаута запроса и времена ответа сервера. Рассмотрим пример:

Пусть:
* бэкенд отвечает в 99p за 0.1 секунду
* таймаут на запрос 2 секунды
* 3 попытки на запрос
* множитель задержки бэкоффа 2
* стартовая задержка 0.5 секунды

Тогда в худшем случае на запрос уйдет 0.1 + (0.5 + 0.1) + (2 * 0.5 + 0.1) = 1.8 секунды, что укладывается в таймаут и оставляет некий запас на случай проседания таймингов.

### Jitter
Если ошибки вызваны тем, что все клиенты делают запросы одновременно, то простых ретраев с бэкоффом может оказаться недостаточно. Клиенты будут ретраить в одно и то же время и опять получать ошибки:

![img](https://jing.yandex-team.ru/files/kharybin/retries_without_jitter.png)

Чтобы этого избежать, во времена задержек вносится случайность:

![img](https://jing.yandex-team.ru/files/kharybin/retries_with_jitter.png)

В cluster_client-е всегда используется jitter вместе с экспоненциальным бэкоффом.

### Отключение ретраев со стороны сервера
Сервер может сообщить cluster_client-у, что какой-то конкретный запрос ретраить не нужно. Для этого в ответ нужно добавить заголовок X-Request-NoRetry.

### Мониторинг ретраев
Чтобы облегчить диагностику аварий, cluster_client вместе с запросом передает в заголовке X-Request-Attempt номер попытки. Нумерация начинается с нуля. Т.е. 0 это исходный запрос, 1, 2, 3 - ретраи. Это позволяет понимать на стороне сервера какие клиенты генерируют какой объем ретраев.

![img](https://jing.yandex-team.ru/files/kharybin/Xiva_tech_2020-01-17_18-04-58.png)

### Ссылки
* [Introducing Retry Throttling](https://aws.amazon.com/ru/blogs/developer/introducing-retry-throttling/)
* [Exponential Backoff And Jitter](https://aws.amazon.com/ru/blogs/architecture/exponential-backoff-and-jitter/)
* [gRPC Retry Design Proposal](https://github.com/grpc/proposal/blob/master/A6-client-retries.md#proposal)
* [Google SRE book](https://landing.google.com/sre/books/)
