## Стратегии балансировки

### Мотивация
В большинстве случаев приложение ходит в бэкенды через балансер. В этом случае можно не задумываться о стратегиях и не указывать никаких дополнительных настроек.

Однако, иногда возникает необходимость в более сложных конфигурациях - например, схема primary/fallback или схема с клиентской балансировкой без использования балансера. Для решения подобных задач используются стратегии балансировки. В cluster_client-е на данный момент есть две стратегии: линейная и на основе взвешенного рандома.

### Линейная стратегия
Хосты перебираются по порядку. Исходный запрос всегда делается на первый хост из списка. Если он завершился с ошибкой, то ретрай делается на второй хост. Следующий ретрай - на третий хост. И т.д. Когда cluster_client обойдет весь список хостов, он начнет сначала.

Базовая конфигурация (дополнительно нужно настроить [ретраи](retries.md)):
```yaml
nodes: [ http://primary, http://fallback ] # список хостов
select_strategy: linear
```

### Стратегия weighted random select
Балансировка выполняется на основе взвешенного рандома. Веса вычисляются динамически в зависимости от статистики ответов сервера.

Рассмотрим пример. Нагрузка равномерно распределяется по 3 серверам, но на 45 секунде один из них начинает пятисотить. В этот момент его вес падает почти до нуля и нагрузка резко уходит на другие сервера. После того как он начнет отвечать нормально, нагрузка плавно вернется обратно.

![img](https://jing.yandex-team.ru/files/kharybin/wrs_graph.png)

Распределение весов можно посмотреть в выдаче статсервера:

```json
"wrs_weights": {
    "node1": "0.333333",
    "node2": "0.333333",
    "node3": "0.333333"
}
```

Базовая конфигурация:
```yaml
nodes: [ http://node1, http://node2, http://node3 ] # список хостов
select_strategy: weighted_random
stats_period: 5 # статистика WRS считается за последние 5 секунд
wrs:
    factor: 2 # чем больше factor, тем агрессивнее троттлятся сбоящие сервера
    ignore_last_failed: true  # не ретраить два раза подряд в один и тот же хост
```

Настройка ```stats_period``` общая для бюджета ретраев и WRS.

Для более тонкой конфигурации нужно смотреть на распределение нагрузки на стрельбах (дополнительные параметры описаны [здесь](wrs_settings.md)).
