## Контекст задачи

Все запросы через клиент сопровождаются контекстом задачи - экземпляром класса [yplatform::task_context](../../yplatform/doc/task_context.md).

Этот подход применяется почти во всех модулях и служит нескольким целям:

- обеспечивает сквозное логирование

  Все исходящие HTTP запросы в рамках одной задачи можно найти поиском по одному идентификатору контекста.

- прокидывание и логирование идентификатора запроса

  Клиент добавляет в исходящие запросы заголовок `X-Request-Id` — со значением идентификатора запроса из контекста задачи, если это значение непусто, или уникального идентификатора, иначе.
  Если задана настройка `name_of_request_id_field`, поле `request_id` также логируется в TSKV-лог как поле с указанным в этой настройке именем.

- прокидывание дедлайна

  Клиент учитывает в таймауте запроса глобальный дедлайн из контекста и добавляет в запрос заголовок ```X-Request-Timeout```, содержащий таймаут в миллисекундах. Это помогает контролировать выполнение задач по всему стеку распределенных компонентов сервиса.

  [Подробнее о deadline propagation](../../yplatform/doc/deadline_propagation.md).

- отмены запросов

  Запрос можно отменить до начала его выполнения. Это делается через task_context::cancel() вручную либо автоматически при остановке приложения (при условии, что контекст задачи есть в [репозитории контекстов](../../yplatform/doc/guide/app_resources.md#репозиторий-контекстов)).
