#include <ymod_httpclient/cluster_client.h>
#include <yplatform/log.h>
#include <boost/property_tree/json_parser.hpp>
#include <iostream>

using namespace std;

int main()
{
    boost::asio::io_service io;
    yhttp::cluster_client::settings st;
    // yplatform::log::init_console(io);
    // st.enable_logging = 1;
    // st.logger = "global";
    st.nodes = { "httpstat.us/200", "httpstat.us/500" };
    st.retry_policy.max_attempts = 1;
    st.retry_policy.codes = { 500 };
    st.select_strategy = yhttp::cluster_client::settings::weighted_random;
    st.wrs.factor = 1;

    unsigned counter_net_error = 0;
    unsigned counter200 = 0;
    unsigned counter500 = 0;
    unsigned total = 0;

    yhttp::cluster_client client(io, st);
    for (int i = 0; i < 20; ++i)
    {
        auto ctx = boost::make_shared<yplatform::task_context>("ctx" + std::to_string(i));
        client.async_run(
            ctx,
            yhttp::request::GET("/"),
            [&](boost::system::error_code ec, yhttp::response response) {
                ++total;
                if (ec)
                {
                    counter_net_error++;
                }
                else
                {
                    if (response.status == 200) ++counter200;
                    else
                        ++counter500;
                }
                cout << ".";
            });
        io.run_for(std::chrono::seconds(2));
        io.reset();
    }

    cout << endl;

    cout << "total: " << total << endl;
    cout << "net_error: " << counter_net_error << endl;
    cout << "200: " << counter200 << endl;
    cout << "500: " << counter500 << endl;

    cout << "stats: ";
    boost::property_tree::write_json(cout, client.get_stats());
    cout << endl;

    return 0;
}
