#include <ymod_httpclient/h2/client.h>
#include <yplatform/log.h>
#include <yplatform/time_traits.h>
#include <boost/asio.hpp>
#include <boost/noncopyable.hpp>
#include <functional>
#include <iostream>
#include <string>

using namespace std;

int main()
{
    boost::asio::io_service io;
    ymod_httpclient::h2::client cl(io);

    auto ctx = boost::make_shared<yplatform::task_context>();
    auto r = ymod_httpclient::h2::request::GET("https://google.com");
    cl.async_run(ctx, r, [ctx](boost::system::error_code ec, yhttp::response resp) {
        if (ec) cout << "** error: " << ec.message() << endl;
        else
            cout << "** response: " << resp.status << " " << resp.body << endl;
    });

    io.run_for(std::chrono::milliseconds(200));

    return 0;
}
