#include <ymod_httpclient/client.h>
#include <iostream>

int main(int, char*[])
{
    yhttp::client httpclient;
    auto request = yhttp::request::GET("https://push.yandex.ru/ping");
    auto opt = yhttp::options();
    opt.timeouts.total = std::chrono::seconds(1);
    auto task_context = boost::make_shared<yplatform::task_context>();

    httpclient.async_run(
        task_context,
        request,
        opt,
        [](const boost::system::error_code& ec, yhttp::response response) {
            if (ec)
            {
                std::cout << ec.message() << "\n";
            }
            else
            {
                std::cout << "(async) status: " << response.status << ", body: " << response.body
                          << "\n";
            }
        });

    httpclient.async_run(
        task_context,
        request,
        opt,
        [](const boost::system::error_code& ec, yhttp::response response) {
            if (ec)
            {
                std::cout << ec.message() << "\n";
            }
            else
            {
                std::cout << "(async) status: " << response.status << ", body: " << response.body
                          << "\n";
            }
        });

    auto response = httpclient.run(task_context, request, opt);
    std::cout << " (sync) status: " << response.status << ", body: " << response.body << "\n";

    sleep(2); // simply wait for async response
    return 0;
}
