#pragma once

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/settings.h>
#include <ymod_httpclient/request.h>
#include <yplatform/ptree.h>
#include <yplatform/reactor.h>
#include <boost/noncopyable.hpp>

namespace ymod_httpclient {

class client
    : public simple_call
    , public yplatform::log::contains_logger
    , public boost::noncopyable
{
public:
    using callback_type = simple_call::callback_type;
    using settings = simple_call::settings;

    client(const yplatform::ptree& conf = yplatform::ptree());
    client(yplatform::reactor& reactor, const yplatform::ptree& conf = yplatform::ptree());
    client(boost::asio::io_service& io, const yplatform::ptree& conf = yplatform::ptree());
    client(yplatform::reactor& reactor, const settings& settings);
    client(boost::asio::io_service& io, const settings& settings);
    ~client();

    response run(task_context_ptr ctx, request req) override;
    response run(task_context_ptr ctx, request req, const options& options) override;
    void async_run(task_context_ptr ctx, request req, callback_type callback) override;
    void async_run(
        task_context_ptr ctx,
        request req,
        const options& options,
        callback_type callback) override;

    template <typename Callback>
    auto async_run(task_context_ptr ctx, request req, Callback&& callback)
    {
        return simple_call::async_run(
            std::move(ctx), std::move(req), std::forward<Callback>(callback));
    }

    template <typename Callback>
    auto async_run(task_context_ptr ctx, request req, const options& options, Callback&& callback)
    {
        return simple_call::async_run(
            std::move(ctx), std::move(req), options, std::forward<Callback>(callback));
    }

private:
    yplatform::reactor_ptr reactor_;
    shared_ptr<simple_call> impl_;
};

}

namespace yhttp {

using ymod_httpclient::client;

}