#pragma once

#include "interpreters.h"
#include <ymod_httpclient/call.h>
#include <ymod_httpclient/settings.h>
#include <ymod_httpclient/typed_client.h>

namespace ymod_httpclient {

class cluster_client
    : public typed_client<response>
    , public cluster_call
{
public:
    using handler_type = simple_call::callback_type;

    cluster_client(boost::asio::io_service& io, const settings& st) : typed_client(io, st)
    {
    }

    cluster_client(boost::asio::io_service& io, const yplatform::ptree& conf)
        : typed_client(io, settings::from_ptree(conf))
    {
    }

    cluster_client(yplatform::reactor& reactor, const settings& st)
        : typed_client(yplatform::reactor::make_not_owning_copy(reactor), st)
    {
    }

    cluster_client(yplatform::reactor& reactor, const yplatform::ptree& conf)
        : cluster_client(reactor, settings::from_ptree(conf))
    {
    }

    void logger(const yplatform::log::source& logger) // shadows base class method
    {
        typed_client::logger(logger);
    }

    void name(const string& name) // shadows base class method
    {
        typed_client::name(name);
    }

    void async_run(task_context_ptr ctx, request req, callback_type callback) override
    {
        typed_client::async_run(ctx, std::move(req), interpreter, std::move(callback));
    }

    void async_run(
        task_context_ptr ctx,
        request req,
        const options& options,
        callback_type callback) override
    {
        typed_client::async_run(ctx, std::move(req), options, interpreter, std::move(callback));
    }

    template <typename CompletionToken>
    auto async_run(
        task_context_ptr ctx,
        request req,
        const options& options,
        CompletionToken&& token)
    {
        return typed_client::async_run(
            ctx, std::move(req), options, interpreter, std::forward<CompletionToken>(token));
    }

    template <typename CompletionToken>
    auto async_run(task_context_ptr ctx, request req, CompletionToken&& token)
    {
        return typed_client::async_run(ctx, req, interpreter, std::forward<CompletionToken>(token));
    }

private:
    interpreter_as_is interpreter;
};
}

namespace yhttp {

using ymod_httpclient::cluster_client;

}
