#pragma once

#include "request_stat.h"
#include <ymod_httpclient/call.h>
#include <ymod_httpclient/settings.h>

namespace ymod_httpclient::detail {

struct continuation_token
{
    size_t last_selected_node = 0;
};
using continuation_ptr = shared_ptr<continuation_token>;

struct balancing_call_op
{
    using callback_type =
        std::function<void(const boost::system::error_code&, response, continuation_ptr)>;

    balancing_call_op(
        boost::asio::io_service& operation_io,
        yplatform::reactor_ptr http_calls_reactor,
        shared_ptr<settings> st,
        shared_ptr<balancing_settings> balancing_st,
        request_stat_ptr stat);
    void logger(const yplatform::log::source&);
    void name(const string&);

    void operator()(
        task_context_ptr ctx,
        request req,
        const options& options,
        continuation_ptr cont,
        callback_type callback);

    yplatform::ptree get_stats();

private:
    struct impl;
    shared_ptr<impl> impl_;
};

}
