#pragma once

#include <ymod_httpclient/settings.h>
#include <ymod_httpclient/request.h>

namespace ymod_httpclient::detail {

inline timeouts eval_timeouts(
    const task_context_ptr& ctx,
    const options& options,
    const settings& settings)
{
    using time_traits::duration;

    // The limit doesn't allow to freeze a service.
    static const auto MAGIC_MAX_TIMEOUT = time_traits::seconds(60);
    timeouts ret;

    if (options.timeouts.total == duration::max())
        ret.total = settings.default_request_timeout == duration::max() ?
            MAGIC_MAX_TIMEOUT :
            settings.default_request_timeout;
    else
        ret.total = options.timeouts.total;

    if (options.timeouts.connect == duration::max())
    {
        ret.connect = settings.connect_attempt_timeout;
    }
    else
    {
        ret.connect = options.timeouts.connect;
    }
    ret.connect = std::min(ret.total, ret.connect);

    if (ctx->deadline() != time_traits::time_point::max())
    {
        auto timeout = ctx->deadline() - time_traits::clock::now();
        ret.connect = std::min(ret.connect, timeout);
        ret.total = std::min(ret.total, timeout);
    }

    return ret;
}

}
