#pragma once

#include <string>
#include <yplatform/encoding/url_encode.h>
#include <boost/variant.hpp>

namespace ymod_httpclient { namespace detail {

struct value_wrapper
{
    value_wrapper() = default;
    template <typename T>
    value_wrapper(const T& t) : impl(t)
    {
    }
    boost::variant<const char*, const string&, int64_t> impl;
};

template <typename Stream>
struct url_encoder : public boost::static_visitor<>
{
    url_encoder(Stream& s) : s(s)
    {
    }
    void operator()(int64_t v) const
    {
        s << v;
    }
    void operator()(const string& v) const
    {
        s << yplatform::url_encode(boost::make_iterator_range(v));
    }
    void operator()(const char* p) const
    {
        s << yplatform::url_encode(boost::make_iterator_range(p, std::next(p, strlen(p))));
    }

    Stream& s;
};

template <typename Stream>
inline void url_encode(Stream& s, const value_wrapper& w)
{
    boost::apply_visitor(url_encoder<Stream>(s), w.impl);
}

using params_initializer_list = std::initializer_list<std::pair<value_wrapper, value_wrapper>>;

}}
