#pragma once

#include <openssl/ssl.h>
#if OPENSSL_VERSION_NUMBER < 0x10002000L
#error "OpenSSL >1.0.2 is required"
#endif

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/h2/settings.h>
#include <ymod_httpclient/h2/request.h>
#include <ymod_httpclient/h2/stats.h>
#include <yplatform/ptree.h>
#include <yplatform/reactor.h>
#include <boost/noncopyable.hpp>

namespace ymod_httpclient { namespace h2 {

class client
    : public yplatform::log::contains_logger
    , public boost::noncopyable
{
public:
    using handler_type = call::callback_type;
    using stats_handler = std::function<void(stats)>;

    /**
     * HTTP/2 client is designed for use in io_servce-per-thread model only,
     * so user is responsible to run io_service in a single thread.
     */
    client(boost::asio::io_service& io, const settings& st = settings());

    void async_run(task_context_ptr ctx, request req, handler_type handler);
    void async_run(task_context_ptr ctx, request req, const options& options, handler_type handler);

    void async_get_stats(stats_handler handler);

private:
    class impl;
    yplatform::reactor_ptr reactor_;
    shared_ptr<impl> impl_;
};

}}
