#pragma once

namespace ymod_httpclient { namespace h2 {

inline request request::POST(string url, string body)
{
    request result;
    result.url = std::move(url);
    result.method = "POST";
    result.body = std::move(body);
    return result;
}
inline request request::POST(string url, h2::headers headers, string body)
{
    request result;
    result.url = std::move(url);
    result.method = "POST";
    result.headers = std::move(headers);
    result.body = std::move(body);
    return result;
}
inline request request::GET(string url)
{
    request result;
    result.url = std::move(url);
    result.method = "GET";
    return result;
}
inline request request::GET(string url, h2::headers headers)
{
    request result;
    result.url = std::move(url);
    result.method = "GET";
    result.headers = std::move(headers);
    return result;
}
inline request request::HEAD(string url)
{
    request result;
    result.url = std::move(url);
    result.method = "HEAD";
    return result;
}
inline request request::HEAD(string url, h2::headers headers)
{
    request result;
    result.url = std::move(url);
    result.method = "HEAD";
    result.headers = std::move(headers);
    return result;
}

}}
