#pragma once

#include <ymod_httpclient/types.h>
#include <yplatform/time_traits.h>

namespace ymod_httpclient { namespace h2 {

using headers = std::vector<std::pair<string, string>>;
using options = ::ymod_httpclient::options;

class request
{
public:
    static request POST(string url, string body);
    static request POST(string url, h2::headers headers, string body);
    static request GET(string url);
    static request GET(string url, h2::headers headers);
    static request HEAD(string url);
    static request HEAD(string url, h2::headers headers);

    string url;
    string method;
    h2::headers headers;
    string body;
};
}}

#include <ymod_httpclient/h2/impl/request.ipp>
