#pragma once

#include <ymod_httpclient/settings.h>
#include <ymod_httpclient/types.h>

namespace ymod_httpclient { namespace h2 {

struct settings : public ::ymod_httpclient::settings
{
    time_traits::duration connect_timeout = time_traits::seconds(3);
    time_traits::duration tls_timeout = time_traits::seconds(3);
    time_traits::duration read_timeout = time_traits::minutes(30);
    time_traits::duration write_timeout = time_traits::seconds(10);
    size_t max_pool_size = 1U;
    bool log_request_path = false;

    void parse_ptree(const yplatform::ptree& data)
    {
        ::ymod_httpclient::settings::parse_ptree(data);

        // Timeout for all connect attempts. Introduced in h2 client
        // because in http v1 client connect timeout was included in total
        // request timeout. For h2 that's not correct.
        connect_timeout = data.get("connect_timeout", connect_timeout);
        tls_timeout = data.get("tls_timeout", tls_timeout);
        read_timeout = data.get("read_timeout", read_timeout);
        write_timeout = data.get("write_timeout", write_timeout);
        max_pool_size = data.get("max_pool_size", max_pool_size);
        log_request_path = data.get("log_request_path", log_request_path);
    }
};

}}
