#pragma once

namespace ymod_httpclient {

inline multipart body_mixed(post_chunks&& parts)
{
    return { "multipart/mixed", std::move(parts) };
}

inline multipart body_alternative(post_chunks&& parts)
{
    return { "multipart/alternative", std::move(parts) };
}

inline multipart body_form_data(post_chunks&& parts)
{
    return { "multipart/form-data", std::move(parts) };
}

inline post_chunk part(string type, string&& body)
{
    return { std::move(type), std::move(body) };
}

inline post_chunk json_part(string&& body)
{
    return part("application/json", std::move(body));
}

inline post_chunk rfc822_part(string&& body)
{
    return part("message/rfc822", std::move(body));
}

}
