#pragma once

#include <yplatform/util/visit.h>
#include <boost/make_shared.hpp>

namespace ymod_httpclient {

inline request request::POST(string url, string&& body)
{
    request result;
    result.method = method_t::POST;
    result.url = std::move(url);
    result.body = boost::make_shared<string>(std::move(body));
    return result;
}

inline request request::POST(string url, headers_param headers, string&& body)
{
    auto result = POST(std::move(url), std::move(body));
    result.headers = std::move(headers.data);
    return result;
}

inline request request::MPOST(string url, multipart&& body)
{
    request result;
    result.method = method_t::POST;
    result.url = std::move(url);
    result.multipart_body = boost::make_shared<multipart>(std::move(body));
    return result;
}

inline request request::MPOST(string url, headers_param headers, multipart&& body)
{
    auto result = MPOST(std::move(url), std::move(body));
    result.headers = std::move(headers.data);
    return result;
}

inline request request::PUT(string url, string&& body)
{
    request result;
    result.method = method_t::PUT;
    result.url = std::move(url);
    result.body = boost::make_shared<string>(std::move(body));
    return result;
}

inline request request::PUT(string url, headers_param headers, string&& body)
{
    auto result = PUT(std::move(url), std::move(body));
    result.headers = std::move(headers.data);
    return result;
}

inline request request::GET(string url)
{
    request result;
    result.method = method_t::GET;
    result.url = std::move(url);
    return result;
}

inline request request::GET(string url, headers_param headers)
{
    auto result = GET(std::move(url));
    result.headers = std::move(headers.data);
    return result;
}

inline request request::HEAD(string url)
{
    request result;
    result.method = method_t::HEAD;
    result.url = std::move(url);
    return result;
}

inline request request::HEAD(string url, headers_param headers)
{
    auto result = HEAD(std::move(url));
    result.headers = std::move(headers.data);
    return result;
}

inline request request::DELETE(string url)
{
    request result;
    result.method = method_t::DELETE;
    result.url = std::move(url);
    return result;
}

inline request request::DELETE(string url, headers_param headers)
{
    auto result = DELETE(std::move(url));
    result.headers = std::move(headers.data);
    return result;
}

inline void add(request::headers_type& headers, const string& key, const string& value)
{
    yplatform::visit(
        headers,
        [&key, &value](std::string& headers) { headers.append(key + ": " + value + "\r\n"); },
        [&key, &value](header_dict& headers) { headers.emplace(key, value); });
}

inline std::ostream& operator<<(std::ostream& os, const request::headers_type& headers)
{
    yplatform::visit(
        headers,
        [&os](const std::string& headers) { os << headers; },
        [&os](const header_dict& headers) {
            for (auto&& [key, value] : headers)
            {
                os << key << ": " << value << "\r\n";
            }
        });
    return os;
}

}
