namespace ymod_httpclient {

inline string url_encode(const params_initializer_list& params, char prefix)
{
    std::stringstream stream;
    bool first = true;
    for (auto& p : params)
    {
        if (first)
        {
            first = false;
            if (prefix != '\0') stream << prefix;
        }
        else
        {
            stream << "&";
        }
        stream << p.first.impl << "=";
        detail::url_encode(stream, p.second);
    }
    return stream.str();
}

inline string form_encode(const params_initializer_list& params)
{
    return url_encode(params, '\0');
}

}