#pragma once

#include <ymod_httpclient/types.h>
#include <vector>

namespace ymod_httpclient {

typedef std::pair<string, string> post_chunk;
typedef std::vector<post_chunk> post_chunks;

struct multipart
{
    string type;
    post_chunks parts;
};

typedef boost::shared_ptr<multipart> multipart_ptr;

multipart body_mixed(post_chunks&& parts);
multipart body_alternative(post_chunks&& parts);
multipart body_form_data(post_chunks&& parts);
post_chunk part(string type, string&& body);
post_chunk json_part(string&& body);
post_chunk rfc822_part(string&& body);

}

namespace yhttp {

using ymod_httpclient::multipart;
using ymod_httpclient::multipart_ptr;
using ymod_httpclient::body_mixed;
using ymod_httpclient::body_alternative;
using ymod_httpclient::body_form_data;
using ymod_httpclient::part;
using ymod_httpclient::json_part;
using ymod_httpclient::rfc822_part;

}

#include <ymod_httpclient/impl/multipart.ipp>
