#pragma once

#include <ymod_httpclient/types.h>

namespace ymod_httpclient {

enum handler_version
{
    handler_version_initial,
    handler_version_already_parse_body
};

class response_handler
{
public:
    virtual ~response_handler()
    {
    }

    virtual handler_version version() const
    {
        return handler_version_initial;
    }

    virtual void set_code(int /*code*/, const string& /*description*/)
    {
    }

    virtual void handle_header(const string& /*name*/, const string& /*value*/)
    {
    }

    virtual void handle_data(const char* data, unsigned long long size) = 0;

    virtual void handle_data_end()
    {
    }

    virtual int code() const
    {
        return 0;
    }
};

typedef boost::shared_ptr<response_handler> response_handler_ptr;
}

namespace yhttp {

using ymod_httpclient::response_handler_ptr;

}
