#pragma once

#include <ymod_httpclient/response/response_handler.h>

namespace ymod_httpclient {

class status_line_handler : public response_handler
{
public:
    handler_version version() const override
    {
        return handler_version_already_parse_body;
    }

    void set_code(int code, const string& description) override
    {
        code_ = code;
        reason_ = description;
    }

    void handle_data(const char* /*data*/, unsigned long long /*size*/) override
    {
    }

    int code() const override
    {
        return code_;
    }

    const string& reason() const
    {
        return reason_;
    }

private:
    int code_;
    string reason_;
};

}
