#include <ymod_httpclient/detail/balancing_call_op.h>
#include "balancing_call_op_impl.h"
#include "call_impl.h"

namespace ymod_httpclient::detail {

using balancing_call_op_impl_type = balancing_call_op_impl<ymod_httpclient::call_impl>;

struct balancing_call_op::impl : public balancing_call_op_impl_type
{
    impl(
        boost::asio::io_service& operation_io,
        yplatform::reactor_ptr http_calls_reactor,
        shared_ptr<ymod_httpclient::settings> st,
        shared_ptr<balancing_settings> balancing_st,
        request_stat_ptr stat)
        : balancing_call_op_impl_type(
              operation_io,
              balancing_st,
              stat,
              std::make_shared<ymod_httpclient::call_impl>())
    {
        call->init(http_calls_reactor, *st);
    }
};

balancing_call_op::balancing_call_op(
    boost::asio::io_service& operation_io,
    yplatform::reactor_ptr http_calls_reactor,
    shared_ptr<settings> st,
    shared_ptr<balancing_settings> balancing_st,
    request_stat_ptr stat)
    : impl_(std::make_shared<balancing_call_op::impl>(
          operation_io,
          http_calls_reactor,
          st,
          balancing_st,
          stat))
{
}

void balancing_call_op::logger(const yplatform::log::source& logger)
{
    impl_->call->logger(logger);
}

void balancing_call_op::name(const string& name)
{
    impl_->call->name(name);
}

void balancing_call_op::operator()(
    task_context_ptr ctx,
    request req,
    const options& options,
    continuation_ptr cont,
    balancing_call_op::callback_type callback)
{
    (*impl_)(ctx, std::move(req), options, cont, std::move(callback));
}

yplatform::ptree balancing_call_op::get_stats()
{
    return impl_->get_stats();
}

}
