#include <ymod_httpclient/client.h>
#include <yplatform/util/shared_ptr_cast.h>

#include "call_impl.h"

namespace ymod_httpclient {

client::client(const yplatform::ptree& conf)
{
    reactor_ = boost::make_shared<yplatform::reactor>();
    reactor_->init(1, 1);
    auto module = make_shared<call_impl>();
    impl_ = module;
    module->init(reactor_, conf);
    reactor_->run();
}

client::client(yplatform::reactor& reactor, const yplatform::ptree& conf)
{
    reactor_ = yplatform::reactor::make_not_owning_copy(reactor);
    auto module = make_shared<call_impl>();
    impl_ = module;
    module->init(reactor_, conf);
}

client::client(boost::asio::io_service& io, const yplatform::ptree& conf)
{
    reactor_ = boost::make_shared<yplatform::reactor>(make_shared<yplatform::io_pool>(io, 1));
    auto module = make_shared<call_impl>();
    impl_ = module;
    module->init(reactor_, conf);
}

client::client(yplatform::reactor& reactor, const settings& settings)
{
    reactor_ = yplatform::reactor::make_not_owning_copy(reactor);
    auto module = make_shared<call_impl>();
    impl_ = module;
    module->init(reactor_, settings);
}

client::client(boost::asio::io_service& io, const settings& settings)
{
    reactor_ = boost::make_shared<yplatform::reactor>(make_shared<yplatform::io_pool>(io, 1));
    auto module = make_shared<call_impl>();
    impl_ = module;
    module->init(reactor_, settings);
}

client::~client()
{
    impl_.reset();
    if (reactor_)
    {
        reactor_->stop();
        reactor_->fini();
    }
}

response client::run(task_context_ptr ctx, request req)
{
    return impl_->run(ctx, std::move(req));
}

response client::run(task_context_ptr ctx, request req, const options& options)
{
    return impl_->run(ctx, std::move(req), options);
}

void client::async_run(task_context_ptr ctx, request req, callback_type callback)
{
    return impl_->async_run(ctx, std::move(req), std::move(callback));
}

void client::async_run(
    task_context_ptr ctx,
    request req,
    const options& options,
    callback_type callback)
{
    return impl_->async_run(ctx, std::move(req), options, std::move(callback));
}

}
