#pragma once

#include <ymod_httpclient/types.h>
#include <nghttp2/nghttp2.h>
#include <cstring>
#include <string>

namespace ymod_httpclient { namespace h2 { namespace utils {

inline string to_string(const uint8_t* str, size_t len)
{
    return string(reinterpret_cast<const char*>(str), len);
}

inline uint8_t* to_uint8(char* str)
{
    return reinterpret_cast<uint8_t*>(str);
}

inline uint8_t* to_uint8(const char* str)
{
    return const_cast<uint8_t*>(reinterpret_cast<const uint8_t*>(str));
}

inline const uint8_t* to_const_uint8(const char* str)
{
    return reinterpret_cast<const uint8_t*>(str);
}

inline nghttp2_nv make_nv(const char* name, const string& value, bool no_index = false)
{
    uint8_t flags = NGHTTP2_NV_FLAG_NO_COPY_NAME | NGHTTP2_NV_FLAG_NO_COPY_VALUE |
        (no_index ? NGHTTP2_NV_FLAG_NO_INDEX : NGHTTP2_NV_FLAG_NONE);
    return nghttp2_nv{
        to_uint8(name), to_uint8(&value[0]), std::strlen(name), value.size(), flags
    };
}

inline nghttp2_nv make_nv(const string& name, const string& value, bool no_index = false)
{
    uint8_t flags = NGHTTP2_NV_FLAG_NO_COPY_NAME | NGHTTP2_NV_FLAG_NO_COPY_VALUE |
        (no_index ? NGHTTP2_NV_FLAG_NO_INDEX : NGHTTP2_NV_FLAG_NONE);
    return nghttp2_nv{ to_uint8(&name[0]), to_uint8(&value[0]), name.size(), value.size(), flags };
}

}}}