#pragma once

#include <yplatform/time_traits.h>
#include <boost/asio.hpp>

namespace ymod_httpclient { namespace h2 {

namespace time_traits = time_traits;

template <ssize_t Capacity = 64 * 1024>
class write_buffer_t
{
public:
    ssize_t capacity() const
    {
        return Capacity;
    }

    ssize_t free_space() const
    {
        return Capacity - size_;
    }

    ssize_t size() const
    {
        return size_;
    }

    bool empty() const
    {
        return size_ == 0;
    }

    void pick(const uint8_t* buf, ssize_t len)
    {
        if (len > free_space())
        {
            throw std::runtime_error("write_buffer_t::pick buffer too large");
        }
        std::copy_n(buf, len, data_ + size_);
        size_ += len;
    }

    void reset()
    {
        size_ = 0;
    }

    boost::asio::const_buffers_1 as_asio() const
    {
        return boost::asio::buffer(data_, size_);
    }

private:
    uint8_t data_[Capacity];
    ssize_t size_ = 0;
};

}}
