#pragma once

#include <ymod_httpclient/types.h>
#include <boost/algorithm/string/case_conv.hpp>
#include <string>
#include <utility>

namespace ymod_httpclient {

inline bool is_headers_end(const string& line)
{
    return line == "\r" || line.empty();
}

inline bool starts_with_lws(const string& line)
{
    return line.front() == ' ' || line.front() == '\t';
}

inline string& trim_ending_sp(string& line)
{
    auto end_pos = line.find_last_not_of(' ');
    if (end_pos != line.npos) line.resize(end_pos + 1);
    return line;
}

template <class F>
void parse_headers(std::istream& in, F&& handler)
{
    string header;
    string key, value;
    bool headers_found = false;
    while (std::getline(in, header) && !is_headers_end(header))
    {
        if (header.back() == '\r') header.pop_back();

        if (key.size() && starts_with_lws(header))
        {
            value.append(header);
            continue;
        }

        std::size_t column_pos = header.find_first_of(':');
        if (column_pos != header.npos)
        {
            if (headers_found)
            {
                handler(key, trim_ending_sp(value));
                key.clear();
                value.clear();
            }
            key = string(header.begin(), header.begin() + column_pos);
            boost::to_lower(key);
            auto header_start = header.find_first_not_of(' ', column_pos + 1);
            if (header_start != header.npos) value = header.substr(header_start);
            headers_found = true;
        }
        else
        {
            handler(header, header);
        }
    }

    if (headers_found)
    {
        handler(key, trim_ending_sp(value));
    }
}

}
