#pragma once

#include <string>

namespace ymod_httpclient {

inline string replace_tskv_specials(const string& str)
{
    static const string SPECIAL = "\t\r\n";
    static const char* REPLACEMENT[] = { "<TAB>", "<CR>", "<LF>" };

    string ret;
    ret.reserve(str.size());
    for (auto& ch : str)
    {
        auto pos = SPECIAL.find(ch);
        if (pos != string::npos)
        {
            ret += REPLACEMENT[pos];
        }
        else
        {
            ret += ch;
        }
    }
    return ret;
}

}
