#pragma once

#include <yplatform/encoding/url_encode.h>
#include <boost/algorithm/string/case_conv.hpp>
#include <string>

namespace http_parser {

using std::string;

template <typename Range>
inline string convert_range_to_string(const Range& r)
{
    return string(r.begin(), r.end());
}

template <typename Iterator>
inline string encode_param_range(Iterator begin, Iterator end)
{
    return convert_range_to_string(yplatform::url_decode(boost::make_iterator_range(begin, end)));
}

template <typename Iterator>
inline string encode_header_range(Iterator begin, Iterator end)
{
    return string(begin, end);
}

}
