#pragma once

#include <ymod_httpclient/types.h>
#include <string>
#include <iterator>
#include <algorithm>

namespace http_parser {

template <typename Iterator, typename Stream>
struct stream_adaptor
{
    static void move(Iterator begin, Iterator end, std::size_t /*count*/, Stream& output)
    {
        std::copy(begin, end, std::ostream_iterator<typename Iterator::value_type>(output));
    }
};

template <typename Iterator>
struct stream_adaptor<Iterator, string>
{
    static void move(Iterator begin, Iterator end, std::size_t count, string& output)
    {
        output.reserve(output.size() + count);
        output.append(begin, end);
    }
};

}