#pragma once

#include "header_parser.h"
#include "log_util.h"
#include <ymod_httpclient/types.h>
#include <sstream>
#include <unordered_set>

namespace ymod_httpclient {

namespace detail {

inline std::string make_placeholder(std::size_t length)
{
    return std::string(length, 'x');
}

}

// Elements of `headers_to_protect` should be in lower case.
inline std::string prepare_headers_to_log(
    const std::string& headers,
    const std::unordered_set<std::string>& headers_to_protect)
{
    std::istringstream in(headers);
    std::ostringstream out;
    // Usage of `parse_headers` function has undesirable but acceptable side effects:
    // 1. Header names are converted to lower case.
    // 2. Multiline header values collapse into single line.
    parse_headers(in, [&headers_to_protect, &out](auto&& name, auto&& value) {
        static const std::string CRLF = replace_tskv_specials("\r\n");
        out << replace_tskv_specials(name) << ": "
            << (headers_to_protect.contains(name) ? detail::make_placeholder(value.length()) :
                                                    replace_tskv_specials(value))
            << CRLF;
    });
    return std::move(out).str();
}

}
