#include "protocol.h"

namespace ymod_httpclient {

end_of_data_characteristic::end_of_data_characteristic()
    : state_(Eof), content_length_(0), got_last_chunk_(false)
{
}

void end_of_data_characteristic::set_content_length_mode(size_t len)
{
    state_ = CLenght;
    content_length_ = len;
}
void end_of_data_characteristic::set_chunked_mode()
{
    state_ = Chunked;
    got_last_chunk_ = false;
}
void end_of_data_characteristic::set_wait_eof()
{
    state_ = Eof;
}

bool end_of_data_characteristic::is_chunked_mode()
{
    return state_ == Chunked;
}

bool end_of_data_characteristic::is_end()
{
    switch (state_)
    {
    case CLenght:
        return content_length_ == 0;
    case Chunked:
        return got_last_chunk_;

    case Eof:
    default:
        return false;
    }
    return false;
}

// Apply data and check should we stop (true) or read further (false)
bool end_of_data_characteristic::apply(size_t length)
{
    switch (state_)
    {
    case CLenght:
        if (length > content_length_) // ???
            throw std::runtime_error("server has sent more than specified in Content-Length");
        return (content_length_ -= length) == 0;

    case Chunked:
        // the last chunk has size 0
        got_last_chunk_ = (length == 0);
        return got_last_chunk_;

    case Eof:
    default:
        return false;
    }
    return false;
}

bool end_of_data_characteristic::is_wait_eof()
{
    return state_ == Eof;
}

}
