#pragma once

#include "header_container.h"
#include <ymod_httpclient/call.h>
#include <ymod_httpclient/response_handler.h>
#include <yplatform/future/future.hpp>
#include <yplatform/task_context.h>

namespace ymod_httpclient {

struct request_data
{
    request_data()
        : log_post_body(false)
        , log_headers(false)
        , reuse_connection(false)
        , started_at(time_traits::clock::now())
        , total_timeout(time_traits::duration::max())
        , connect_timeout(total_timeout)
        , bytes_out(0U)
        , bytes_in(0U)
        , method(request::method_t::GET)
        , number(0)
    {
    }

    time_traits::time_point deadline() const
    {
        return (total_timeout != time_traits::duration::max()) ? started_at + total_timeout :
                                                                 time_traits::time_point::max();
    }

    bool log_post_body;
    bool log_headers;
    bool reuse_connection;
    task_context_ptr context;
    response_handler_ptr response_handler;
    remote_point_info_ptr remote_point;
    string uri;
    string full_uri;
    header_container headers;
    string_ptr post;
    multipart_ptr mpost;

    std::function<void(http_error::code err, const string& reason)> handler;

    time_traits::time_point started_at;
    time_traits::duration total_timeout;
    time_traits::duration connect_timeout;

    size_t bytes_out;
    size_t bytes_in;
    request::method_t method;

    std::uint64_t number;

    unsigned attempt = 0;
};

typedef shared_ptr<request_data> request_data_ptr;

}
