#pragma once

#include <ymod_httpclient/response_handler.h>

namespace ymod_httpclient {

struct simple_handler : public response_handler
{
    simple_handler()
    {
        result.status = 0;
    }

    handler_version version() const override
    {
        return handler_version_already_parse_body;
    }

    void set_code(int code, const string& description) override
    {
        result.status = code;
        result.reason = description;
    }

    void handle_header(const string& name, const string& value) override
    {
        result.headers.insert(std::make_pair(name, value));
    }

    void handle_data(const char* data, unsigned long long size) override
    {
        result.body.append(data, size);
    }

    int code() const override
    {
        return result.status;
    }

    response result;
};

}
