#include <ymod_httpclient/util/url_parser.h>
#include <boost/algorithm/string.hpp>
#include <boost/regex.hpp>
#include <utility>

namespace ymod_httpclient {

errc parse_url(const string& url, string& proto, string& host, unsigned short& port, string& uri)
{
    static const boost::regex e(
        "^(?:([^:]*)://)?([^/:?]+|\\[[\\:\\d\\.a-fA-F]+?\\])(?::(\\d+))?(?|/(\\S*)|(\\?\\S*)|())$");
    boost::smatch what;
    if (boost::regex_match(url, what, e) == false)
    {
        return errc::invalid_url;
    }

    if (what[1].matched)
    {
        proto.assign(what[1].first, what[1].second);
        boost::to_lower(proto);
    }
    else
    {
        proto.assign("http");
    }

    host.assign(what[2].first, what[2].second);

    port = 0;
    try
    {
        port = boost::lexical_cast<unsigned short>(string(what[3].first, what[3].second));
    }
    catch (const boost::bad_lexical_cast&)
    {
    }

    uri.assign(1, '/');
    uri.append(what[4].first, what[4].second);

    return errc();
}

}
