#ifndef _YMOD_IMAP_CLIENT_ERROR_H_
#define _YMOD_IMAP_CLIENT_ERROR_H_

#include <ymod_imapclient/config.h>
#include <yplatform/exception.h>

#include <boost/tuple/tuple.hpp>
#include <boost/exception/all.hpp>

namespace ymod_imap_client {

class error : public yplatform::exception
{
public:
    inline error() : yplatform::exception()
    {
    }

    explicit inline error(const string& cl) : yplatform::exception(cl, string(), string())
    {
    }

    inline error(const string& cl, string const& pub) : yplatform::exception(cl, pub, string())
    {
    }

    inline error(const string& cl, string const& pub, string const& prv)
        : yplatform::exception(cl, pub, prv)
    {
    }

    virtual inline ~error() throw()
    {
    }
};

struct resolve_error
    : YPLATFORM_ERROR_DEF(resolve_error, error, "ymod_imap_client::error", "resolve error");

struct connect_error
    : YPLATFORM_ERROR_DEF(connect_error, error, "ymod_imap_client::error", "connect error");

struct ssl_error
    : YPLATFORM_ERROR_DEF(ssl_error, error, "ymod_imap_client::error", "ssl handshake error");

struct transport_error
    : YPLATFORM_ERROR_DEF(transport_error, error, "ymod_imap_client::error", "transport error");

struct login_error
    : YPLATFORM_ERROR_DEF(login_error, error, "ymod_imap_client::error", "login error");

struct server_response_error
    : YPLATFORM_ERROR_DEF(
          server_response_error,
          error,
          "ymod_imap_client::error",
          "bad server response");

struct server_yandex_db_error
    : YPLATFORM_ERROR_DEF(server_yandex_db_error, error, "ymod_imap_client::error", "");

struct server_format_error
    : YPLATFORM_ERROR_DEF(
          server_format_error,
          error,
          "ymod_imap_client::error",
          "bad server response format");

struct connection_timeout
    : YPLATFORM_ERROR_DEF(
          connection_timeout,
          error,
          "ymod_imap_client::error",
          "connection timeout");

typedef boost::error_info<struct tag_url, string> url_info;

typedef boost::error_info<struct tag_proto_name, string> proto_name_info;
typedef boost::error_info<struct tag_host_name, string> host_name_info;
typedef boost::error_info<struct tag_port_num, unsigned int> port_num_info;
typedef boost::error_info<struct tag_uri, string> uri_info;
typedef boost::error_info<struct tag_server_response, string> server_response_info;

typedef boost::tuple<proto_name_info, host_name_info, port_num_info, uri_info> pop_request_info;

// New IMAP client exceptions

//-----------------------------------------------------------------------------
// Imap EXCEPTIONS

struct ImapException : public std::runtime_error
{
    ImapException(const std::string& message) : std::runtime_error(message)
    {
    }

    std::shared_ptr<string> serverResponse;
};

struct TimeoutException : public ImapException
{
    TimeoutException(const std::string& command, const std::string& reason)
        : ImapException(string("Timeout for command \"") + command + "\": " + reason)
    {
    }
};

struct NoException : public ImapException
{
    NoException(const std::string& command, const std::string& reason)
        : ImapException(string("Server returns NO for \"") + command + "\": " + reason)
        , reason(reason)
    {
    }
    std::string reason;
};
struct BadException : public ImapException
{
    BadException(const std::string& command, const std::string& reason)
        : ImapException(string("Server returns BAD for \"") + command + "\": " + reason)
    {
    }
};

struct FatalException : public ImapException
{
    FatalException(const std::string& command, const std::string& reason)
        : ImapException(string("Fatal server ERROR after \"") + command + "\": " + reason)
    {
    }
};

struct InternalClientError : public ImapException
{
    InternalClientError(const std::string& command, const std::string& reason)
        : ImapException(string("Internal client error for command \"") + command + "\": " + reason)
    {
    }
};

struct ResolveException : public ImapException
{
    ResolveException(const std::string& reason) : ImapException(string("Resolve error: ") + reason)
    {
    }
};

struct ConnectException : public ImapException
{
    ConnectException(const std::string& reason) : ImapException(string("Connect error: ") + reason)
    {
    }
};

}
#endif // _YMOD_HTTP_CLIENT_HTTP_ERRORS_H_
