#ifndef _YMOD_IMAPCLIENT_IMAP_CLIENT_H_
#define _YMOD_IMAPCLIENT_IMAP_CLIENT_H_

#include "statistics.h"

#include <memory>
#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>
#include <ymod_imapclient/imap_result.h>
#include <ymod_imapclient/verbosity_settings.h>

namespace ymod_imap_client {

enum class FetchArg
{
    Uid = 0,
    Flags,
    Date,
    Size,
    Body,

    GmailLabels,

    COUNT
};

using FetchArgs = std::set<FetchArg>;

class ImapClient
{
public:
    virtual ~ImapClient()
    {
    }

    enum OauthLoginType
    {
        Multiline,
        SinglelineQuoted,
        SinglelineLiteral
    };

    virtual FutureConnectResult connect(const string& server, unsigned short port, bool ssl) = 0;

    virtual FutureConnectResult connect(
        const string& server,
        const string& serverLoggingAlias,
        unsigned short port,
        bool ssl) = 0;

    virtual FutureCapability capability() = 0;

    virtual FutureIdResult id(const string& idData = "") = 0;

    virtual FutureImapResult startTls() = 0;

    virtual FutureImapResult login(const string& user, const string& password) = 0;

    virtual FutureImapResult loginOauth(
        const string& user,
        const string& accessToken,
        OauthLoginType type) = 0;

    virtual FutureImapResult authPlain(const string& user, const string& password) = 0;

    virtual FutureImapList list(
        const std::string& refName = "",
        const std::string& mailbox = "*") = 0;

    virtual FutureImapStatus status(const Utf8MailboxName& mailbox, const string& fields) = 0;

    virtual FutureImapMailbox examine(const Utf8MailboxName& mailbox) = 0;

    virtual FutureImapResult select(const Utf8MailboxName& mailbox) = 0;

    virtual FutureMessageSet fetch(const string& seqset, const FetchArgs& args) = 0;

    virtual FutureMessageSet uidFetch(const string& seqset, const FetchArgs& args) = 0;

    virtual FutureImapResult noop() = 0;

    virtual FutureImapResult logout() = 0;

    virtual FutureImapResult createMailbox(const Utf8MailboxName& mailbox) = 0;

    virtual FutureImapResult deleteMailbox(const Utf8MailboxName& mailbox) = 0;

    virtual FutureImapResult renameMailbox(
        const Utf8MailboxName& oldMailbox,
        const Utf8MailboxName& newMailbox) = 0;

    virtual FutureImapResult expunge() = 0;

    virtual FutureMessageSet uidStore(
        const std::string& seqset,
        const std::string& storeType,
        const std::string& args) = 0;

    virtual FutureCopyuidResult uidMove(
        const std::string& seqset,
        const Utf8MailboxName& newMailbox) = 0;

    virtual FutureCopyuidResult uidCopy(
        const std::string& seqset,
        const Utf8MailboxName& newMailbox) = 0;

    virtual FutureAppenduidResult append(
        std::string&& body,
        const Utf8MailboxName& mailbox,
        const std::string& flags,
        const std::string& date) = 0;

    virtual void setVerbose(const VerbositySettings& verbosity) = 0;

    virtual string serverIp() const = 0;

    virtual Statistics getStats() = 0;

    virtual void setCommandTimeout(const yplatform::time_traits::duration& timeout) = 0;
};

typedef std::shared_ptr<ImapClient> ImapClientPtr;

} // namespace ymod_imap_client

#endif // _YMOD_IMAPCLIENT_IMAP_CLIENT_H_
