#ifndef _YMOD_IMAP_CLIENT_IMAPUIDLS_H_
#define _YMOD_IMAP_CLIENT_IMAPUIDLS_H_

#include <string>
#include <vector>
#include <map>
#include <boost/shared_ptr.hpp>
#include <yplatform/future/future.hpp>
#include <ymod_imapclient/imap_response.h>

namespace ymod_imap_client {

struct MailboxInfo
{
    uint32_t uidvalidity_ = 0;
    uint32_t nextuid_ = 0;
    uint32_t exists_ = 0;
    uint32_t recent_ = 0;
    uint32_t unseen_ = 0;
};

struct imap_msg
{
    std::string body;
    std::vector<Utf8Label> xgmlabels;
};

typedef boost::shared_ptr<imap_msg> imap_msg_ptr;
typedef boost::shared_ptr<string> string_ptr;

struct ImapIdInfo : public std::string
{
    void addPair(const string& first, const string& second)
    {
        if (!empty()) *this += " ";
        *this += "\"" + first + "\" \"" + second + "\"";
    }
};
typedef std::shared_ptr<ImapIdInfo> ImapIdInfoPtr;

}

#endif /* _YMOD_IMAP_CLIENT_IMAPUIDLS_H_ */
