include(find_ymod_imapclient_dependencies)

if(YMOD_IMAPCLIENT_INCLUDE_DIR AND YMOD_IMAPCLIENT_LIBRARIES)
  set(YMOD_IMAPCLIENT_FIND_QUIETLY TRUE)
endif()

find_path(YMOD_IMAPCLIENT_INCLUDE_DIR
  NAMES ymod_imapclient/call.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(YMOD_IMAPCLIENT_LIBRARY
  NAMES ymod_imapclient
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_ymod_imapclient_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(YMOD_IMAPCLIENT DEFAULT_MSG
  YMOD_IMAPCLIENT_INCLUDE_DIR YMOD_IMAPCLIENT_LIBRARY)

if(YMOD_IMAPCLIENT_FOUND)
  list(APPEND YMOD_IMAPCLIENT_INCLUDE_DIR ${YMOD_IMAPCLIENT_DEPENDENCY_INCLUDE_DIRS})
  set(YMOD_IMAPCLIENT_LIBRARIES
    "-Wl,--whole-archive ${YMOD_IMAPCLIENT_LIBRARY} -Wl,--no-whole-archive"
    ${YMOD_IMAPCLIENT_DEPENDENCY_LIBRARIES}
  )
endif()

mark_as_advanced(YMOD_IMAPCLIENT_INCLUDE_DIR YMOD_IMAPCLIENT_LIBRARIES)
