#include "client_service.h"
#include "imap_client_impl.h"
#include <ymod_imapclient/verbosity_settings.h>

#include <yplatform/module_registration.h>

namespace ymod_imap_client {

ClientService::ClientService() : yplatform::net::client_module<ClientSession>("imap_client")
{
    L_(debug) << "imap_client task instaniated";
}

ClientService::~ClientService()
{
    L_(debug) << "imap_client task destroyed";
    client_->stop();
}

void ClientService::init(const yplatform::ptree& xml)
{
    if (!yplatform::net::client_module<ClientSession>::open_client(xml))
    {
        L_(fatal) << "invalid imap client options";
        throw std::runtime_error("invalid imap client options");
    }

    defaultIdInfo = std::make_shared<ImapIdInfo>();
    auto data = xml.get_child("id_data");
    for (auto& entry : data)
    {
        defaultIdInfo->addPair(entry.first, entry.second.get_value<string>());
    }
    auto verbosityOpt = xml.get_child_optional("verbosity_settings");
    if (verbosityOpt)
    {
        verbosity.clientRequest = verbosityOpt->get("client_request", false);
        verbosity.serverResponse = verbosityOpt->get("server_response", false);
        verbosity.serviceInfo = verbosityOpt->get("service_info", false);
    }
    defaultTimeout = xml.get("default_timeout", defaultTimeout);
}

void ClientService::fini()
{
    client_->stop();
}

void ClientService::start(void)
{
    run_client();
}

ImapClientPtr ClientService::clientInstance(yplatform::task_context_ptr context)
{
    return clientInstance(context, verbosity);
}

ImapClientPtr ClientService::clientInstance(
    yplatform::task_context_ptr context,
    const VerbositySettings& verbosity)
{
    auto sess = this->client_->create_session(settings_);
    sess->logger(logger());
    sess->set_context(context);
    sess->set_verbose(verbosity);
    sess->setCommandTimeout(defaultTimeout);

    return std::make_shared<ImapClientImpl>(sess, context, defaultIdInfo);
}

} // namespace ymod_imap_client

DEFINE_SERVICE_OBJECT(ymod_imap_client::ClientService)
