#ifndef _YMOD_IMAPCLIENT_CLIENT_SERVICE_H_
#define _YMOD_IMAPCLIENT_CLIENT_SERVICE_H_

#include "client_session.h"
#include <ymod_imapclient/call.h>
#include <yplatform/net/module.h>
#include <yplatform/time_traits.h>

namespace ymod_imap_client {

class ClientService
    : public call
    , public yplatform::net::client_module<ClientSession>
{
public:
    ClientService();

    virtual ~ClientService();

    void init(const yplatform::ptree& xml);

    void fini(void);

    void start();

    virtual const yplatform::module_stats_ptr get_module_stats() const
    {
        return client_->stats();
    }

    virtual ImapClientPtr clientInstance(yplatform::task_context_ptr context);
    virtual ImapClientPtr clientInstance(
        yplatform::task_context_ptr context,
        const VerbositySettings& verbosity);

private:
    ImapIdInfoPtr defaultIdInfo;
    VerbositySettings verbosity = VerbositySettings(false);
    yplatform::time_traits::duration defaultTimeout = yplatform::time_traits::milliseconds(5000);
};

}

#endif // _YMOD_IMAPCLIENT_CLIENT_SERVICE_H_
